package csbase.logic;

/**
 * Informaes simples sobre a finalizao de um comando (utilizada para guardar
 * informaes algoritmos simples ou de fluxos sem as informaes individuais
 * dos ns).
 */
public class SimpleCommandFinalizationInfo extends
  AbstractCommandFinalizationInfo {

  /**
   * Construtor.
   *
   * @param finalizationType tipo de finalizao do comando.
   * @param hasWarnings Indica se o comando gerou log de alertas durante sua
   *        execuo.
   */
  public SimpleCommandFinalizationInfo(CommandFinalizationType finalizationType,
    boolean hasWarnings) {
    this(finalizationType, hasWarnings, null);
  }

  /**
   * Construtor.
   *
   * @param finalizationType tipo de finalizao do comando.
   * @param failureCause o tipo da falha que causou a finalizao do comando ou
   * null caso o comando no tenha falhado.
   */
  public SimpleCommandFinalizationInfo(CommandFinalizationType finalizationType,
    FailureFinalizationType failureCause) {
    this(finalizationType, false, failureCause, null);
  }

  /**
   * Construtor.
   *
   * @param finalizationType tipo de finalizao do comando.
   * @param hasWarnings Indica se o comando gerou log de alertas durante sua
   *        execuo.
   * @param exitCode cdigo de sada do comando.
   */
  public SimpleCommandFinalizationInfo(CommandFinalizationType finalizationType,
    boolean hasWarnings, Integer exitCode) {
    this(finalizationType, hasWarnings, null, exitCode);
  }

  /**
   * Construtor.
   *
   * @param finalizationType tipo de finalizao do comando.
   * @param hasWarnings Indica se o comando gerou log de alertas durante sua
   *        execuo.
   * @param failureCause o tipo da falha que causou a finalizao do comando ou
   * null caso o comando no tenha falhado.
   * @param exitCode cdigo de sada do comando.
   */
  public SimpleCommandFinalizationInfo(CommandFinalizationType finalizationType,
    boolean hasWarnings, FailureFinalizationType failureCause, Integer exitCode) {
    super(FinalizationInfoType.SIMPLE, finalizationType, failureCause,
      hasWarnings, exitCode);
  }

}
