package csbase.logic.algorithms;

/**
 * O observador de eventos do {@link AlgorithmConfigurator}.
 */
public interface AlgorithmConfiguratorListener {

  /**
   * Indica que o rtulo de um parmetro foi modificado.
   * 
   * @param configurator O configurao (No aceita {@code null}).
   * @param parameterName O nome do parmetro (No aceita {@code null}).
   * @param parameterLabel O rtulo do parmetro (No aceita {@code null}).
   */
  void parameterLabelWasChanged(AlgorithmConfigurator configurator,
    String parameterName, String parameterLabel);

  /**
   * Indica que o estado habilitado/destabilidado de um parmetro foi 
   * modificado.
   * 
   * @param configurator O configurao (No aceita {@code null}).
   * @param parameterName O nome do parmetro (No aceita {@code null}).
   * @param parameterIsEnabled Indica se o parmetro est 
   *        habilitado ({@code true}) ou desabilitado ({@code false}).
   */
  void parameterWasSetEnabled(AlgorithmConfigurator configurator,
                              String parameterName, boolean parameterIsEnabled);

  /**
   * Indica que o estado visvel/oculto de um parmetro foi modificado.
   * 
   * @param configurator O configurao (No aceita {@code null}).
   * @param parameterName O nome do parmetro (No aceita {@code null}).
   * @param parameterIsVisible Indica se o parmetro est 
   *        visvel ({@code true}) ou oculto ({@code false}).
   */
  void parameterWasSetVisible(AlgorithmConfigurator configurator,
                               String parameterName, boolean parameterIsVisible);

  /**
   * Indica que o valor de um parmetro foi modificado.
   * 
   * @param <V> O tipo do valor.
   * 
   * @param configurator O configurao (No aceita {@code null}).
   * @param parameterName O nome do parmetro (No aceita {@code null}).
   * @param parameterValue O valor do parmetro (Aceita {@code null}).
   */
  <V> void parameterValueWasChanged(AlgorithmConfigurator configurator,
    String parameterName, V parameterValue);
  
  /**
   * Indica que o estado habilitado/desabilitado do configurador de algoritmos
   * foi modificado.
   * 
   * @param configurator O configurao (No aceita {@code null}).
   */
  void wasSetEnabled(AlgorithmConfigurator configurator);
}
