/*
 * $Id$
 */
package csbase.logic.algorithms;

import java.io.Serializable;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

/**
 * Estrutura que mantm as informaes necessrias para a importao do arquivo
 * de pacote de algoritmos.
 */
public class ImportAlgorithmsPackTransferInfo implements Serializable {
  /** Canal ftc de transferncia do arquivo que representa o PA */
  private RemoteFileChannelInfo channel;

  /** Identificador nico de um dado de importao de PA */
  private String importDataToken;

  /**
   * Construtor.
   * 
   * @param channel Canal ftc de transferncia do arquivo que representa o
   *        pacote de algoritmos.
   * @param importDataToken Identificador nico de um dado de importao de
   *        pacote de algoritmos.
   */
  public ImportAlgorithmsPackTransferInfo(RemoteFileChannelInfo channel,
    String importDataToken) {
    super();
    this.channel = channel;
    this.importDataToken = importDataToken;
  }

  /**
   * Retorna o canal ftc de transferncia do arquivo que representa o pacote de
   * algoritmos.
   * 
   * @return channel Canal ftc de transferncia do arquivo que representa o
   *         pacote de algoritmos.
   */
  public RemoteFileChannelInfo getChannel() {
    return channel;
  }

  /**
   * Define o canal ftc de transferncia do arquivo que representa o pacote de
   * algoritmos.
   * 
   * @param channel Canal ftc de transferncia do arquivo que representa o
   *        pacote de algoritmos.
   */
  public void setChannel(RemoteFileChannelInfo channel) {
    this.channel = channel;
  }

  /**
   * Retorna o identificador nico de um dado de importao de pacote de
   * algoritmos.
   * 
   * @return importDataToken Identificador nico de um dado de importao de
   *         pacote de algoritmos.
   */
  public String getImportDataToken() {
    return importDataToken;
  }

  /**
   * Define o identificador nico de um dado de importao de pacote de
   * algoritmos.
   * 
   * @param importDataToken Identificador nico de um dado de importao de
   *        pacote de algoritmos.
   */
  public void setImportDataToken(String importDataToken) {
    this.importDataToken = importDataToken;
  }

}
