package csbase.logic.algorithms.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.URLProtocol;

/**
 * <p>
 * Analisador de {@link OutputURLListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "url de sada" mltiplo. O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link OutputURLListParameter}.
 * </p>
 * 
 */
public class OutputURLListParameterParser extends
  AbstractURLParameterParser<OutputURLListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputURLListParameter createURLParameter(XmlParser parser, 
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, String[] types,
    String localization, FileParameterMode mode, FileURLValue defaultValue,
    FileParameterPipeAcceptance usesPipe, EnumSet<URLProtocol> allowedProtocols)
    throws ParseException {

    if (types != null && types.length > 1) {
      throw new ParseException(
        "URL de sada (seleo mltipla) no admite mltiplos tipos de" + " " +
          "arquivo");

    }

    boolean mustSort =
      parser.extractAttributeValueAsBoolean(MUST_SORT_ATTRIBUTE,
        MUST_SORT_DEFAULT_VALUE);

    List<FileURLValue> defaultValues =
      defaultValue == null ? null : Arrays.asList(defaultValue);
    return new OutputURLListParameter(name, label, description, defaultValues,
      isOptional, isVisible, commandLinePattern, localization, types, mode,
      mustSort, allowedProtocols);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(OutputURLListParameter.class);
  }
}
