/**
 * $Id$
 */
package csbase.logic.diagnosticservice;

import java.io.Serializable;
import java.util.Date;

/**
 * Informaes consolidadas com as estatsticas do servidor.
 * 
 * @author Tecgraf
 */
public class ServerStatisticsInfo implements Serializable {
  /**
   * Estatsticas sobre usurios
   */
  public final UsersStatisticsInfo usersStatisticsInfo;
  /**
   * Estatsticas sobre o login
   */
  public final LoginStatisticsInfo loginStatisticsInfo;
  /**
   * Estatsticas sobre a execuo de comandos
   */
  public final CommandExecutionStatisticsInfo commandExecutionStatisticsInfo;

  /** Data/Hora que as informaes se referem */
  public final Date time;

  /**
   * Construtor.
   * 
   * @param usersStatisticsInfo estatsticas sobre usurios
   * @param loginStatisticsInfo estatsticas sobre o login
   * @param commandExecutionStatisticsInfo estatsticas sobre a execuo de
   *        comandos
   * @param time Data/Hora que as informaes foram obtidas
   */
  public ServerStatisticsInfo(UsersStatisticsInfo usersStatisticsInfo,
    LoginStatisticsInfo loginStatisticsInfo,
    CommandExecutionStatisticsInfo commandExecutionStatisticsInfo, Date time) {
    this.usersStatisticsInfo = usersStatisticsInfo;
    this.loginStatisticsInfo = loginStatisticsInfo;
    this.commandExecutionStatisticsInfo = commandExecutionStatisticsInfo;
    this.time = time;
  }
}
