/*
 * $Id$
 */
package csbase.logic.filetransferservice;

import java.io.Serializable;

/**
 * Objeto da lgica que representa um arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileTransferElement implements Serializable {

  /**
   * Nome
   */
  final private String name;

  /**
   * Flag de diretrio
   */
  final private boolean isDirectory;

  /**
   * Flag de link
   */
  final private boolean isLink;

  /**
   * Tamanho
   */
  final private long sizeBytes;

  /**
   * Consulta o valor de name
   * 
   * @return o valor
   */
  public final String getName() {
    return name;
  }

  /**
   * Consulta o tamanho do elemento em bytes
   * 
   * @return o tamanho
   */
  public final long getSizeBytes() {
    return sizeBytes;
  }

  /**
   * Indica se elemento  diretrio
   * 
   * @return o indicativo
   */
  public final boolean isDirectory() {
    return isDirectory;
  }

  /**
   * Indica se elemento  isLink
   * 
   * @return o indicativo
   */
  public final boolean isLink() {
    return isLink;
  }

  /**
   * Construtor
   * 
   * @param name nome do elemento
   * @param isDirectory indicativo de diretrio
   * @param size tamanho (em bytes)
   * @param isLink indicativo de link
   */
  public FileTransferElement(final String name, final boolean isDirectory,
    final long size, final boolean isLink) {
    this.name = name;
    this.isDirectory = isDirectory;
    this.sizeBytes = size;
    this.isLink = isLink;
  }
}
