/*
 * $Id: FileTransferPredefinedConnection.java 91986 2009-05-29 18:03:44Z clinio
 * $
 */

package csbase.logic.filetransferservice;

import java.io.Serializable;

import csbase.remote.FileTransferServiceInterface;

/**
 * Conexo para o servio de transferncia de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 * @see FileTransferServiceInterface
 */
public class FileTransferPredefinedConnection implements Serializable {

  /**
   * Tipo da conexo.
   */
  final private FileTransferProtocol connectionType;

  /**
   * Nome/endereo do servidor
   */
  final private String serverName;

  /**
   * Nome do usurio no servidor
   */
  final private String userName;

  /**
   * Rtulo
   */
  final private String label;

  /**
   * Path para o conceito de HOME
   */
  final private String homePath;

  /**
   * @return o campo homeString
   */
  public final String getHomePath() {
    return homePath;
  }

  /**
   * Retorna o rtulo da conexo.
   * 
   * @return o rtulo
   */
  public final String getLabel() {
    return label;
  }

  /**
   * Consulta o tipo da conexo
   * 
   * @return o tipo
   */
  public final FileTransferProtocol getProtocol() {
    return connectionType;
  }

  /**
   * Consulta o nome/endereo do servidor
   * 
   * @return o nome/endereo
   */
  public final String getServerName() {
    return serverName;
  }

  /**
   * Consulta o nome de usurio no servidor
   * 
   * @return o nome
   */
  public final String getUserName() {
    return userName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    final String protName = getProtocol().toString();
    return protName + "://" + getUserName()+"@"+getServerName();
  }
  
  /**
   * Construtor
   * 
   * @param label rtulo da conexo.
   * @param connectionType tipo da conexo.
   * @param serverName nome do servidor remoto
   * @param userName nome do usurio remoto
   * @param homePath path para o home
   */
  public FileTransferPredefinedConnection(final String label,
    final FileTransferProtocol connectionType, final String serverName,
    final String userName, final String homePath) {
    this.connectionType = connectionType;
    this.serverName = serverName;
    this.userName = userName;
    this.label = label;
    this.homePath = homePath;
  }
}
