/*
 * $Id$
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.Hashtable;

import csbase.logic.applicationservice.ApplicationCategory;
import csbase.logic.applicationservice.ApplicationRegistry;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

/**
 * Interface do servio de gerncia de aplicaes.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ApplicationServiceInterface extends ServiceInterface,
  TransactionInterface, RemoteObservable {

  /**
   * Nome do servio para o {@code ServiceManager}
   */
  public static final String SERVICE_NAME = "ApplicationService";

  /**
   * Consulta as aplicaes definidas pelo sistema
   * 
   * @return a hash
   * @throws RemoteException em caso de erro.
   */
  public Hashtable<String, ApplicationRegistry> getApplicationRegistries()
    throws RemoteException;

  /**
   * Consulta as listas de categorias definidas pelo sistema
   * 
   * @return a hash
   * @throws RemoteException em caso de erro
   */
  public Hashtable<String, ApplicationCategory> getApplicationCategories()
    throws RemoteException;

  /**
   * Encontra um recurso dado seu path.
   *
   * @param appId id da aplicao.
   * @param resourcePath path do recurso desejado.
   * @return Um objeto {@link RemoteFileChannelInfo}, ou {@code null} se o
   * recurso no for encontrado.
   * 
   * @throws RemoteException em caso de erro.
   */
  public RemoteFileChannelInfo getApplicationResource(String appId,
    String[] resourcePath) throws RemoteException;

  /**
   * Pedido de recarga das aplicaes.
   * 
   * @return true caso a recarga tenha sido efetuada com sucesso.
   * 
   * @throws RemoteException Erro de RMI.
   */
  public boolean reloadApplications() throws RemoteException;

  /**
   * Busca o registro de uma aplicao especfica pelo seu identificador.
   * 
   * @param id o identificador.
   * @return o registro da aplicao.
   */
  public ApplicationRegistry getApplicationRegistry(String id);
}
