/*
 * ProjectSynchronizationMonitor.java
 * $Author$
 * $Revision$ - $Date$
 */
package csbase.remote;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface remota do monitor da sincronizao de projetos. Objetos deste tipo
 * podem monitorar operaes de sincronizao de projetos, recebendo resultados
 * parciais, o resultado final e podendo indicar o cancelamento da operao.
 */
public interface ProjectSynchronizationMonitor extends Remote {
  
  /**
   * Sinaliza o incio da transferncia de um arquivo.
   * @param file o caminho para o arquivo que a transferncia iniciou
   * @throws RemoteException caso ocorra alguma falha de rmi
   */
  public void initTransfer(String file) throws RemoteException;
  /**
   * Resultado parcial da transferncia do arquivo <code>file</code>. O valor
   * de <code>result</code> ser nulo caso a transferncia tenha sido realizada
   * com sucesso. Caso contrrio, ser um texto descritivo do erro ocorrido.
   * @param file O caminho do arquivo em questo.
   * @param result A descrio do erro ocorrido na transferncia do arquivo ou
   *               null caso no tenha ocorrido nenhum erro.
   * @throws RemoteException caso ocorra alguma falha de rmi
   */
  public void partialResult(String[] file, String result)
  throws RemoteException;

  /**
   * Resultado geral da operao de transferncia. O texto ser null caso
   * nenhum erro geral tenha ocorrido. Um erro geral  um erro no relacionado
   *  transferncia de algum arquivo em particular. Caso um erro geral ocorra,
   * a operao de transferncia  interrompida no ponto em que ela estiver. 
   * @param result A descrio do erro geral ocorrido ou null caso no tenha
   *               ocorrido nenhum erro geral.
   * @throws RemoteException caso ocorra alguma falha de rmi
   */
  public void finalResult(String result) throws RemoteException;

  /**
   * Este mtodo indica para o servidor se o cliente deseja interromper a
   * operao de sincronizao ou no. O servidor deve chamar este mtodo no
   * mnimo ao trmino da transferncia de cada arquivo.
   * @return <code>true</code> para cancelar a operao, <code>false</code>
   *         caso contrrio.
   * @throws RemoteException caso ocorra alguma falha de rmi
   */
  public boolean isCancelled() throws RemoteException;
}
