/*
 * ProjectSynchronizationServiceInterface.java
 * $Author$
 * $Revision$ - $Date$
 */
package csbase.remote;

import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationListProjects;
import csbase.logic.ProjectSynchronizationResult;

import java.rmi.RemoteException;

/**
 * Interface remota para acesso ao servio de sincronizao de projetos. Este
 * servio permite que projetos locais sejam sincronizados com projetos
 * remotos, isto , projetos de outros servidores.
 */
public interface ProjectSynchronizationServiceInterface
extends ServiceInterface {

  /** Nome do servio para o <code>ServiceManager</code> */
  public static final String SERVICE_NAME = "ProjectSynchronizationService";

  /**
   * Constri as listas de arquivos a serem transferidos para que haja a
   * sincronizao completa entre os dois projetos especificados. O objeto
   * fornecido deve conter os dados completos dos dois projetos envolvidos na
   * operao de sincronizao. Para projetos locais, isso significa informar
   * o nome do projeto e o identificador de seu usurio administrador. Para
   * projetos remotos,  necessrio informar o endereo do servidor, a chave
   * do usurio e a senha a serem utilizados na conexo com este servidor, o
   * nome do projeto e o identificador de seu usurio administrador.
   * O objeto retornado mantm todos esses dados inalterados, mas sobrescreve
   * as listas de arquivos A e B. A lista de arquivos A  composta por todos
   * os arquivos do projeto A e a de arquivos B por todos os arquivos do
   * projeto B.
   * As listas so concretizadas na forma de mapeamentos entre caminhos e
   * objetos do tipo ProjectSynchronizationFileInfo.
   * O atributo <code>transfer</code> da cada elemento da lista de arquivos A
   *  ajustado de forma a indicar que os arquivos a serem enviados de A para B
   * sero os que s existem no projeto A ou que existem em ambos mas tenham
   * sido alterados mais recentemente em A. De forma anloga, o atributo
   * <code>transfer</code> da cada elemento da lista de arquivos B  ajustado
   * de forma a indicar que os arquivos a serem enviados de B para A sero os
   * que s existem no projeto B ou que existem em ambos mas tenham sido
   * alterados mais recentemente em B.
   * @param data deve conter os dados completos dos dois projetos envolvidos na
   *        operao de sincronizao.
   * @return objeto que mantm os dados recebidos e inclui as listas de
   *         arquivos A e B, com indicao de quais devem ser enviados de A
   *         para B e de B A para que a sincronizao seja feita.
   * @throws RemoteException falha de rmi
   */
  public ProjectSynchronizationData buildTransferMaps(
    ProjectSynchronizationData data) throws RemoteException;

  /**
   * Sincroniza dois projetos. O <code>ProjectSynchronizationData</code>
   * fornecido deve estar completamente especificado. O resultado informa se
   * a sincronizao foi realizada ou se algum erro ocorreu. Alm disso, 
   * fornecido um resultado para cada arquivo que deveria ser transferido.
   * O monitor fornecido  chamado durante o processo de sincronizao com os
   * resultados parciais do processo. Esse monitor tambm  chamado para que o
   * cliente possa cancelar a operao de sincronizao.
   * @param data os dados para a sincronizao.
   * @param monitor o monitor da operao de sincronizao, que pode ser nulo.
   * @return resultado da sincronizao dos projetos.
   * @throws RemoteException falha de rmi 
   */
  public ProjectSynchronizationResult synchronizeProjects(
    ProjectSynchronizationData data, ProjectSynchronizationMonitor monitor)
    throws RemoteException;
  
  /**
   * Retorna as listas contendo os nomes de todos projetos dos servidores de
   * origem e destino.
   * @param data os dados para obter as listas.
   * @return objeto contendo as listas de nomes dos projetos.
   * @throws RemoteException falha de rmi
   */
  public ProjectSynchronizationListProjects buildListProjects(
		    ProjectSynchronizationData data) throws RemoteException;
}
