/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.Serializable;
import java.util.Arrays;

public class FileNodeInfo
implements Comparable,
Serializable {
    private String name;
    private long size;
    private long lastUpdateDate;
    private FileNodeInfo parent;
    private FileNodeInfo[] children;
    private boolean isDirectory;
    private String type;
    private String renderingName;

    public FileNodeInfo[] getChildren() {
        return this.children;
    }

    public void setChildren(FileNodeInfo[] children) {
        if (children != null) {
            Arrays.sort(children);
        }
        this.children = children;
    }

    public Object getChild(int index) {
        if (this.children == null) {
            throw new IllegalStateException("children == null");
        }
        return this.children[index];
    }

    public Object getChild(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!name.equals(this.children[i].name)) continue;
            return this.children[i];
        }
        return null;
    }

    public FileNodeInfo getNode(String[] path) {
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return this;
        }
        FileNodeInfo node = this;
        for (int i = 0; i < path.length; ++i) {
            if ((node = (FileNodeInfo)node.getChild(path[i])) != null) continue;
            return null;
        }
        return node;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.length;
    }

    public int getIndexOfChild(Object child) {
        if (this.children == null) {
            throw new IllegalStateException("children == null");
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!child.equals(this.children[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(long lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public FileNodeInfo getParent() {
        return this.parent;
    }

    public void setParent(FileNodeInfo parent) {
        this.parent = parent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getPath() {
        if (this.parent == null) {
            return new String[0];
        }
        String[] parentPath = this.parent.getPath();
        int parentCount = parentPath.length;
        String[] path = new String[parentCount + 1];
        System.arraycopy(parentPath, 0, path, 0, parentCount);
        path[parentCount] = this.name;
        return path;
    }

    public boolean childrenWereRetrieved() {
        return this.children != null;
    }

    public String toString() {
        return this.getRenderingName();
    }

    public int compareTo(Object o) {
        if (!(o instanceof FileNodeInfo)) {
            return -1;
        }
        return this.name.compareTo(((FileNodeInfo)o).name);
    }

    public FileNodeInfo[] stringPathToNodePath(String[] strPath) {
        FileNodeInfo child;
        if (strPath == null) {
            return null;
        }
        if (strPath.length == 0) {
            return new FileNodeInfo[]{this};
        }
        FileNodeInfo[] nodePath = new FileNodeInfo[strPath.length + 1];
        nodePath[0] = child = this;
        for (int i = 0; i < strPath.length; ++i) {
            if ((child = (FileNodeInfo)child.getChild(strPath[i])) == null) {
                return null;
            }
            nodePath[i + 1] = child;
        }
        return nodePath;
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public void setRenderingName(String renderingName) {
        this.renderingName = renderingName;
    }

    public String getRenderingName() {
        if (this.renderingName == null) {
            return this.name;
        }
        return this.renderingName;
    }

    public FileNodeInfo(String name, boolean isDirectory, String type) {
        this(name, 0L, 0L, null, null, isDirectory, type);
    }

    public FileNodeInfo(String name) {
        this(name, 0L, 0L, null, null, true, null);
    }

    public FileNodeInfo(String name, long size, long lastUpdateDate, FileNodeInfo parent, FileNodeInfo[] children, boolean isDirectory, String type) {
        this.name = name;
        this.size = size;
        this.lastUpdateDate = lastUpdateDate;
        this.parent = parent;
        if (children != null) {
            Arrays.sort(children);
        }
        this.children = children;
        this.isDirectory = isDirectory;
        this.type = type;
    }
}

