/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import java.text.MessageFormat;

public final class TextColumn
extends BasicColumn<String> {
    private Integer maxCharacters;

    public TextColumn(String id, String label, String defaultValue, boolean isOptional, boolean isEditable, Integer maxCharacters) {
        super(id, label, defaultValue, isOptional, isEditable);
        this.setMaxCharacters(maxCharacters);
    }

    @Override
    public String getItemValueFromText(String itemValue) {
        return itemValue;
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public SimpleParameterValidator<String> getValidator() {
        return new TextParameterValidator(this.isOptional(), this.getMaxCharacters());
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro maxCharacters deveria ser positivo.\nValor encontrado: {0}.", maxCharacters));
        }
        this.maxCharacters = maxCharacters;
    }
}

