/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameterListener;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import tecgraf.openbus.algorithmservice.v1_0.parameters.TextParameterHelper;

public final class TextParameter
extends SimpleParameter<String> {
    private boolean isEditable;
    private transient List<TextParameterListener> listeners = new LinkedList<TextParameterListener>();
    private Integer maxCharacters;

    public TextParameter(String name, String label, String description, String defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maxCharacters) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.setMaxCharacters(maxCharacters);
        this.setEditable(true);
    }

    public void addTextParameterListener(TextParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public String getType() {
        return "TEXT";
    }

    @Override
    public String getIDLType() {
        return TextParameterHelper.id();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        if (this.isEditable != isEditable) {
            this.isEditable = isEditable;
            for (TextParameterListener listener : this.listeners) {
                listener.editabilityWasChanged(this);
            }
        }
    }

    @Override
    public void setValueAsText(String parameterValue) {
        this.setValue(parameterValue);
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro maxCharacters deveria ser positivo.\nValor encontrado: {0}.", maxCharacters));
        }
        this.maxCharacters = maxCharacters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<TextParameterListener>();
    }

    public TextParameterValidator createParameterValidator() {
        return new TextParameterValidator(this.isOptional(), this.getMaxCharacters());
    }
}

