/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;

public final class ChangeMaximumForIntegersTrigger
extends Trigger<SimpleParameter<?>> {
    private Integer maximum;

    public ChangeMaximumForIntegersTrigger(IntegerParameter parameter, Condition condition, Integer maximum) {
        super(parameter, condition);
        this.maximum = maximum;
    }

    public ChangeMaximumForIntegersTrigger(IntegerListParameter parameter, Condition condition, Integer maximum) {
        super(parameter, condition);
        this.maximum = maximum;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChangeMaximumForIntegersTrigger trigger = (ChangeMaximumForIntegersTrigger)obj;
        if (this.maximum == null && trigger.maximum == null) {
            return true;
        }
        return this.maximum != null && this.maximum.equals(trigger.maximum);
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    @Override
    protected void doAction() {
        SimpleParameter parameter = (SimpleParameter)this.getParameter();
        if (parameter instanceof IntegerListParameter) {
            IntegerListParameter intListParameter = (IntegerListParameter)parameter;
            intListParameter.setMaximum(this.getMaximum());
        } else if (parameter instanceof IntegerParameter) {
            IntegerParameter intParameter = (IntegerParameter)parameter;
            intParameter.setMaximum(this.getMaximum());
        } else {
            throw new IllegalStateException(MessageFormat.format("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2}.", parameter.getLabel(), "real", "lista_de_reais"));
        }
    }

    @Override
    protected void undoAction() {
    }
}

