/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parsers.XmlParser;

public class ParameterLoaderParser {
    static final String PARAMETER_LOADER_ELEMENT = "carregar_parametros";
    static final String INPUT_PARAMETER_ELEMENT = "parametro_de_entrada";
    private static final String PARAMETER_LOADER_ELEMENT_ALGORITHM_ATTRIBUTE = "algoritmo";
    private static final String PARAMETER_LOADER_ELEMENT_OUTPUT_ATTRIBUTE = "saida";
    private static final String PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE = "versao";
    private static final String PARAMETER_LOADER_ELEMENT_VALIDATION_ATTRIBUTE = "validar_entrada";
    private static final String INPUT_PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";

    public void loadParameterLoader(XmlParser parser, ParameterGroup group) throws ParseException {
        String algorithmName = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_ALGORITHM_ATTRIBUTE);
        String algorithmVersionIdStr = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE);
        AlgorithmVersionId algorithmVersionId = AlgorithmVersionId.create(algorithmVersionIdStr);
        if (algorithmVersionId == null) {
            throw new ParseException("Vers\u00e3o inv\u00e1lida do atributo {0} do elemento {1}.", PARAMETER_LOADER_ELEMENT_VERSION_ATTRIBUTE, PARAMETER_LOADER_ELEMENT);
        }
        String outputParameterName = parser.extractAttributeValue(PARAMETER_LOADER_ELEMENT_OUTPUT_ATTRIBUTE);
        boolean validate_input = parser.extractAttributeValueAsBoolean(PARAMETER_LOADER_ELEMENT_VALIDATION_ATTRIBUTE, true);
        ParameterLoader parameterLoader = new ParameterLoader(algorithmName, algorithmVersionId, outputParameterName, validate_input);
        if (parser.goToFirstChild()) {
            do {
                parser.ensureElementName(INPUT_PARAMETER_ELEMENT);
                String inputParameterName = null;
                inputParameterName = parser.extractAttributeValue(INPUT_PARAMETER_ELEMENT_NAME_ATTRIBUTE);
                if (!parameterLoader.addInputParameterName(inputParameterName)) {
                    throw new ParseException("O par\u00e2metro {0} referenciado pelo elemento {1} j\u00e1 existe.", inputParameterName, INPUT_PARAMETER_ELEMENT);
                }
                parser.checkAttributes();
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
        parser.checkAttributes();
        if (!group.setParameterLoader(parameterLoader)) {
            throw new ParseException("J\u00e1 existe um carregador de par\u00e2metros para o grupo {0}.", group);
        }
    }
}

