/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.AbstractTableColumnFactory;

public final class IntegerColumnFactory
extends AbstractTableColumnFactory {
    private static final String ELEMENT_NAME = "coluna_de_inteiros";

    public IntegerColumnFactory() {
        super(ELEMENT_NAME);
    }

    @Override
    public void setCellValue(XmlParser parser, String parameterName, TableColumn<?> column, int rowIndex, String valueAttributeName) throws ParseException {
        IntegerColumn integerColumn = (IntegerColumn)column;
        Integer cellValue = parser.extractAttributeValueAsInteger(valueAttributeName, null, integerColumn.getMaximum(), integerColumn.getMinimum());
        integerColumn.addDefaultValue(rowIndex, cellValue);
    }

    protected IntegerColumn createColumn(XmlParser parser, String parameterName, String label, String id, boolean isOptional, boolean isEditable, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Integer maximum = parser.extractAttributeValueAsInteger("maximo", null, null, null);
        Integer minimum = parser.extractAttributeValueAsInteger("minimo", null, maximum, null);
        Integer defaultValue = parser.extractAttributeValueAsInteger("padrao", null, maximum, minimum);
        parser.checkAttributes();
        parser.checkChildElements();
        return new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
    }
}

