/*
 * $Author$ $Date$
 * $Release: $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * <p>
 * Representa os tempos finais de execuo de um comando. Os metodos desta
 * classe nao devem lancar excecoes, uma vez que so chamados por metodos que
 * definem a idl sga-manager.
 * </p>
 * 
 * <p>
 * Todos os tempos esto em segundos.
 * </p>
 */
public final class CommandFinalTime implements Serializable {
  /**
   * O tempo de parede.
   */
  private int elapsedTime;

  /**
   * O tempo do usurio.
   */
  private int userTime;

  /**
   * O tempo do sistema.
   */
  private int cpuTime;

  /**
   * Cria as informaes finais de execuo de um comando.
   * 
   * 
   * @param elapsedTime O tempo de parede.
   * @param userTime O tempo do usurio.
   * @param cpuTime O tempo do sistema.
   * 
   */
  public CommandFinalTime(int elapsedTime, int userTime, int cpuTime) {
    this.elapsedTime = elapsedTime;
    this.userTime = userTime;
    this.cpuTime = cpuTime;
  }

  /**
   * Obtm o tempo de parede.
   * 
   * @return O tempo de parede.
   */
  public int getElapsedTime() {
    return this.elapsedTime;
  }

  /**
   * Obtm o tempo do usurio.
   * 
   * @return O tempo do usurio.
   */
  public int getUserTime() {
    return this.userTime;
  }

  /**
   * Obtm o tempo do sistema.
   * 
   * @return O tempo do sistema.
   */
  public int getCpuTime() {
    return this.cpuTime;
  }
}
