/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.MonitoredServer;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerURI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class ServerManagerData {
    private Map<ServerURI, MonitoredServer> servers;
    private ServerURI defaultServerURI;
    private final ReentrantLock defaultServerLock = new ReentrantLock();
    private List<MonitoredServerListener> commonListeners;
    private boolean verbose = true;
    private static ServerManagerData instance = new ServerManagerData();

    protected ServerManagerData() {
        this.servers = new Hashtable<ServerURI, MonitoredServer>();
        this.commonListeners = Collections.synchronizedList(new ArrayList());
    }

    protected static ServerManagerData getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MonitoredServer getMonitoredServer(ServerURI uri) {
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            MonitoredServer sdata = this.servers.get(uri);
            if (sdata == null) {
                throw new IllegalStateException(MessageFormat.format("Servidor {0} n\u00e3o est\u00e1 na monitora\u00e7\u00e3o.", uri));
            }
            return sdata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDefaultServer(ServerURI serverURI) {
        if (serverURI == null) {
            throw new IllegalArgumentException("serverURI == null");
        }
        try {
            this.defaultServerLock.lock();
            Map<ServerURI, MonitoredServer> map = this.servers;
            synchronized (map) {
                if (this.defaultServerURI != null) {
                    this.getMonitoredServer(this.defaultServerURI).setAsDefaultServer(false);
                }
                this.getMonitoredServer(serverURI).setAsDefaultServer(true);
            }
            this.defaultServerURI = serverURI;
            this.printInfo("Servidor default = " + serverURI);
        }
        finally {
            this.defaultServerLock.unlock();
        }
    }

    private void printInfo(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    protected final ServerURI getDefaultURI() {
        try {
            this.defaultServerLock.lock();
            ServerURI serverURI = this.defaultServerURI;
            return serverURI;
        }
        finally {
            this.defaultServerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isMonitored(ServerURI serverURI) {
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            return this.servers.containsKey(serverURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeServer(ServerURI serverURI) {
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            this.getMonitoredServer(serverURI).flush();
            this.servers.remove(serverURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServer(MonitoredServer monitoredServer) {
        ServerURI uri = monitoredServer.getURI();
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            this.servers.put(uri, monitoredServer);
            if (this.servers.keySet().size() == 1 && this.getDefaultURI() == null) {
                this.setDefaultServer(uri);
            }
            this.addCommonListeners(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ServerURI> getManagedServers() {
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            return new HashSet<ServerURI>(this.servers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void submitCommonListeners() {
        List<MonitoredServerListener> list = this.commonListeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.commonListeners) {
                for (MonitoredServer ms : this.servers.values()) {
                    ms.addListener(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCommonListeners(ServerURI serverURI) {
        MonitoredServer ms = this.getMonitoredServer(serverURI);
        List<MonitoredServerListener> list = this.commonListeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.commonListeners) {
                ms.addListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addCommonListener(MonitoredServerListener l) {
        List<MonitoredServerListener> list = this.commonListeners;
        synchronized (list) {
            if (!this.commonListeners.contains(l)) {
                this.commonListeners.add(l);
                this.submitCommonListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteCommonListener(MonitoredServerListener l) {
        List<MonitoredServerListener> list = this.commonListeners;
        synchronized (list) {
            if (!this.commonListeners.contains(l)) {
                return;
            }
            for (MonitoredServer ms : this.servers.values()) {
                ms.deleteListener(l);
            }
            this.commonListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Map<ServerURI, MonitoredServer> map = this.servers;
        synchronized (map) {
            for (MonitoredServer data : this.servers.values()) {
                data.flush();
            }
            this.servers.clear();
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

