/**
 * $Id$
 */

package csbase.logic;

/**
 * Representa o evento de modificao de informaes de um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectInfoModifiedEvent extends ProjectEvent {
  /**
   * As informaes do projeto
   */
  private CommonProjectInfo info;

  /**
   * Retorna as novas informaes de um projeto, que foram modificadas no
   * servidor como resultado do evento ocorrido.
   * 
   * @return As informaes do projeto que foram modificadas ou
   *         <code>null</code> caso no seja esse o evento que o objeto est
   *         representando.
   */
  public CommonProjectInfo getInfo() {
    return info;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de
   * modificao de informaes de um projeto.
   * 
   * @param projectId o identificador do projeto
   * @param info O objeto da classe <code>ProjectInfo</code> que possui as novas
   *        informaes do projeto.
   */
  public ProjectInfoModifiedEvent(Object projectId, CommonProjectInfo info) {
    event = INFO_MODIFIED;
    this.projectId = projectId;
    this.info = info;
  }
}
