/*
 * UserGroupInfo.java
 *
 * $Author$
 * $Revision$  - $Date$
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe <code>UserGroupInfo</code> representa os dados de um UserGroup.
 */
public class UserGroupInfo implements Serializable, Cloneable {
  public String name;
  public String desc;

  public Object clone() {
    try {
      return super.clone();
    }
    catch (CloneNotSupportedException e) {
      return null;
    }
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof UserGroupInfo)) {
      return false;
    }
    UserGroupInfo info = (UserGroupInfo)obj;
    return name.equals(info.name) && desc.equals(info.desc);
  }

  /**
   * Calcula o cdigo hash do objeto.
   *
   * @return Inteiro que representa o cdigo hash do objeto.
   */
  public int hashCode() {
    return ( name + desc ).hashCode();
  }

  /**
   * Cria um UserGroupInfo.
   *
   * @param name identificao da UserGroup
   * @param desc descrio da UserGroup
   */
  public UserGroupInfo(String name, String desc) {
    this.name = (name == null) ? "" : name;
    this.desc = (desc == null) ? "" : desc;
  }
}
