/*
 * $Id$
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Contm os dados bsicos de identificao de um projeto de um usurio.
 * 
 * @author Taciana
 * @version $Revision$
 */
public class UserProjectInfo implements Serializable,
  Comparable<UserProjectInfo> {
  /**
   * Identificador do projeto.
   */
  private Object projectId;

  /**
   * Nome do projeto
   */
  private String projectName;

  /**
   * Identificador do usurio dono do projeto
   */
  private Object ownerId;

  /**
   * Obtm o identificador do projeto.
   * 
   * @return O identificador do projeto.
   */
  public Object getProjectId() {
    return projectId;
  }

  /**
   * Obtm o nome do projeto.
   * 
   * @return O nome do projeto.
   */
  public String getProjectName() {
    return projectName;
  }

  /**
   * Obtm o identificador do usurio dono do projeto.
   * 
   * @return O identificador do usurio.
   */
  public Object getOwnerId() {
    return ownerId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (this == obj) {
      return true;
    }
    if (!(obj instanceof UserProjectInfo)) {
      return false;
    }
    UserProjectInfo info = (UserProjectInfo) obj;
    return ((this.projectId == info.projectId) || this.projectId
      .equals(info.projectId))
      && ((this.projectName == info.projectName) || this.projectName
        .equals(info.projectName))
      && ((this.ownerId == info.ownerId) || this.ownerId.equals(info.ownerId));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    String str = projectName + ownerId.toString();
    return str.hashCode();
  }

  /**
   * Constri um <code>UserProjectInfo</code> com as informaes sobre um
   * projeto e seu dono.
   * 
   * @param projectId Identificador do projeto.
   * @param projectName Nome do projeto.
   * @param ownerId Identificador do usurio dono do projeto.
   */
  public UserProjectInfo(Object projectId, String projectName, Object ownerId) {
    this.projectId = projectId;
    this.projectName = projectName;
    this.ownerId = ownerId;
  }

  /**
   * Constri um <code>UserProjectInfo</code> com as informaes sobre um
   * projeto e seu dono, a partir de um CommonProjectInfo.
   * 
   * @param cpi CommonProjectInfo que representa o projeto.
   */
  public UserProjectInfo(CommonProjectInfo cpi) {
    this(cpi.projectId, cpi.name, cpi.userId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return this.projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(UserProjectInfo info) {
    return this.toString().compareTo(info.toString());
  }
}
