package csbase.logic.algorithms.parsers;

import java.util.Collections;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Analisador de {@link DoubleListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de reais".O elemento
 * corrente do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link DoubleListParameter}.
 * </p>
 * 
 */
public class DoubleListParameterFactory extends
  AbstractDoubleParameterParser<DoubleListParameter> {

  /**
   * <p>
   * O elemento {@value #DOUBLE_LIST_PARAMETER_ELEMENT}: descreve as
   * propriedades de um {@link DoubleListParameter parmetro do tipo lista de
   * reais}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String DOUBLE_LIST_PARAMETER_ELEMENT = "lista_de_reais";

  /**
   * {@inheritDoc}
   */
  @Override
  protected DoubleListParameter createDoubleParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, Double maximum,
    boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded)
      throws ParseException {
    return new DoubleListParameter(name, label, description, null, isOptional,
      isVisible, commandLinePattern, maximum, isMaximumIncluded, minimum,
      isMinimumIncluded);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(DoubleListParameter.class);
  }

}
