package csbase.logic.algorithms;

import java.io.File;
import java.io.Serializable;

import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;

/**
 * Classe que representa uma fbrica de caminho absoluto para um arquivo de
 * release notes de uma verso de algoritmo.
 */
public class ReleaseNotesPathFactory implements IPathFactory, Serializable {

  /**
   * Verso do algoritmo.
   */
  private AlgorithmVersionInfo version;

  /**
   * Construtor
   * 
   * @param version Verso do algoritmo.
   */
  public ReleaseNotesPathFactory(AlgorithmVersionInfo version) {
    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPath(FileInfo fileInfo) {
    return version.getReleaseNotesDirPath() + File.separator + fileInfo
      .getPath();
  }
}
