package csbase.logic;

import java.util.Comparator;

/**
 * Implementao do comparador de ClientProjectFile por tipo de arquivo.
 * 
 * Ordenao: diretrio pai quando existir (..), seguido dos diretrios
 * ordenados alfabeticamente, seguidos dos tipos de arquivos ordenados
 * alfabeticamente.
 * 
 * @author tatimf
 */
public class FileTypeComparator implements Comparator<ClientProjectFile> {

  /**
   * {@inheritDoc}
   */
  @Override
  public int compare(ClientProjectFile file1, ClientProjectFile file2) {
    final boolean d1 = file1.isDirectory();
    final boolean d2 = file2.isDirectory();
    if (d1 != d2) {
      if (d1) return -1;
      else return 1;
    }
    final String typeName = file1.getType();
    final String typeName2 = file2.getType();
    return (typeName.compareTo(typeName2));
  }
}
