/**
 * $Id: LogFile.java 175455 2016-08-15 14:56:29Z isabella $
 */
package csbase.logic;

import java.io.Serializable;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

/**
 * A classe <code>LogFile</code> representa um arquivo de log localizado no
 * servidor.
 * 
 * @author Tecgraf
 */
public class LogFile implements Serializable {
  /**
   * Nome do arquivo
   */
  public String name;

  /**
   * Indicador se  um diretrio
   */
  public boolean isDirectory;

  /**
   * Canal para a leitura dos dados do arquivo
   */
  public RemoteFileChannelInfo channel;

  /**
   * Filhos do arquivo de log (somente para diretrios)
   */
  public LogFile[] children;

  /**
   * Construtor
   * 
   * @param name nome
   * @param isDirectory indicador de diretrio
   * @param channel canal de leitura dos dados
   * @param children filhos deste arquivo
   */
  public LogFile(String name, boolean isDirectory,
    RemoteFileChannelInfo channel, LogFile[] children)  {
    this.name = name;
    this.isDirectory = isDirectory;
    if (!this.isDirectory) {
      this.channel = channel;
    }
    else {
      this.children = children;
    }
  }
}
