package csbase.logic;

/**
 * Enumerao de estados de alocao onde um projeto pode se encontrar.
 * 
 * @author jnlopes
 */
public enum ProjectAllocationState {

  /**
   * Estado de um projeto bloqueado devido a requisio de rea.
   */
  WAITING_AREA_ALLOCATION(0),

  /**
   * Estado de um projeto desbloqueado que usa uma rea reservada.
   */
  UNLOCKED_WITH_AREA_ALLOCATED(1),

  /**
   * Estado de um projeto removido aguardando liberao de rea.
   */
  WAITING_AREA_FREE(2),

  /**
   * Estado de projeto sem alocao.
   */
  NO_ALLOCATION(3);

  /**
   * Cdigo do estado.
   */
  final private int code;

  /**
   * Construtor.
   * 
   * @param code Cdigo do estado.
   */
  private ProjectAllocationState(final int code) {
    this.code = code;
  }

  /**
   * Retorna o cdigo do estado de alocao do projeto.
   * 
   * @return Cdigo do estado de alocao do projeto.
   */
  public int getCode() {
    return code;
  }

  /**
   * Retorna uma instncia de {@link ProjectAllocationState} em funo do cdigo
   * de alocao do projeto.
   * 
   * @param code Cdigo de alocao do projeto.
   * @return Instncia de {@link ProjectAllocationState} em funo do cdigo de
   *         alocao do projeto.
   */
  public static ProjectAllocationState getProjectAllocationStateFromCode(
    final int code) {
    for (ProjectAllocationState pas : values()) {
      if (pas.getCode() == code) {
        return pas;
      }
    }
    return null;
  }

}
