/*
 * ProjectArgObserver.java
 *
 * $Author: brunoos $
 * $Revision: 34611 $  - $Date: 2004-10-19 07:40:53 -0300 (Tue, 19 Oct 2004) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Representa um argumento para observao de um projeto especfico.
 *
 * @author Taciana
 * @version $Revision: 34611 $
 */
public class ProjectArgObserver implements Serializable {
  /** Identificador do usurio dono do projeto */
  private Object userId;
  /** Nome do projeto */
  private String projectName;

  /**
   * Obtm o identificador do dono projeto.
   *
   * @return O identificador do dono projeto.
   */
  public Object getUserId() {
    return userId;
  }

  /**
   * Obtm o nome do projeto.
   *
   * @return O nome do projeto.
   */
  public String getProjectName(){
    return projectName;
  }

  /**
   * Testa se um <code>ProjectArgObserver</code>  igual a um outro 
   * objeto. Dois objetos <code>ProjectArgObserver</code> so iguais 
   * de forem da mesma classe e se possuirem as mesmas informaes.
   *
   * @param obj .
   *
   * @return Verdadeiro, se os objetos forem iguais ou falso, caso contrrio.
   */
  public boolean equals(Object obj) {
    if (!(obj instanceof ProjectArgObserver)) {
      return false;
    }
    ProjectArgObserver info = (ProjectArgObserver)obj;
    return (((this.userId == info.userId) || 
      this.userId.equals(info.userId)) &&
      ((this.projectName==info.projectName) || 
       (this.projectName.equals(info.projectName))));
  }

  /**
   * Cdigo hash do objeto.
   *
   * @return inteiro representando o cdigo hash.
   */
  public int hashCode() {
     // XXX Atributos podem ser nulos?
     String str = (projectName == null) ? "projectNameNull" : projectName;
     str += (userId == null) ? "userIdNull" : Integer.toString(userId.hashCode());

     return str.hashCode();
  }
 
  /**
   * Constri um <code>ProjectArgObserver</code> com as informaes 
   * sobre um projeto e seu dono.
   *
   * @param userId Identificador do dono projeto.
   * @param projectName Nome do projeto.
   */
  public ProjectArgObserver(Object userId, String projectName) {
    this.userId = userId;
    this.projectName = projectName;
  }
}
