package csbase.logic;

/**
 * Enumerao de atributos de projeto.
 * 
 * @author jnlopes
 */
public enum ProjectAttribute {

  /**
   * Tamanho da rea reservada para o projeto.
   */
  LOCKING_AREA_SIZE("lockingAreaSize"),

  /**
   * Configurao dos frames.
   */
  FRAME_CONFIG("frameConfig"),

  /**
   * Nome do atributo que informa a data de criao do projeto
   */
  CREATION_DATE("CREATION_DATE"),

  /**
   * Nome do servidor que criou o determinado projeto.
   */
  SERVER_NAME("serverName");

  /**
   * Chave do atributo.
   */
  final private String attributeKey;

  /**
   * Construtor.
   * 
   * @param attributeKey Chave do atributo.
   */
  private ProjectAttribute(final String attributeKey) {
    this.attributeKey = attributeKey;
  }

  /**
   * Retorna a chave do atributo.
   * 
   * @return Chave do atributo.
   */
  public String getAttributeKey() {
    return attributeKey;
  }

}
