package csbase.logic.algorithms;

/**
 * Representa os dados de um algoritmo para ser mostrado no cliente para um
 * algoritmo recente.
 *
 * @author Tecgraf/PUC-Rio
 */
public class RecentAlgorithmInfo extends AlgorithmInfo {

  /**
   * Posio do algoritmo na lista de algoritmos recentes.
   */
  private Integer position;

  /**
   * Constri um algoritmo a partir de um algoritmo base.
   * 
   * @param algorithmInfo algoritmo base
   * @param position posio do algoritmo na lista de algoritmos recentes.
   */
  public RecentAlgorithmInfo(AlgorithmInfo algorithmInfo, int position) {
    super(algorithmInfo);
    this.position = position;
  }

  /**
   * Obtm a posio do algoritmo na lista de algoritmos recentes.
   * 
   * @return posio do algoritmo na lista de algoritmos recentes.
   */
  public Integer getPosition() {
    return position;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(AlgorithmInfo o) {
    if (RecentAlgorithmInfo.class.isInstance(o)) {
      RecentAlgorithmInfo other = (RecentAlgorithmInfo) o;
      return this.position.compareTo(other.getPosition());
    }
    return super.compareTo(o);
  }

}
