/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLElementInterface;

/**
 * Esta classe implementa o elemento XML que representa um conjunto de
 * categorias.
 * 
 */
public class XMLCategorySetElement extends XMLBasicElement {
  /**
   * Lista de nomes completos das categorias, que sero analisados no servidor.
   */
  private List<String> categoryFullNames;

  /**
   * Retorna uma lista de nomes completos das categorias.
   * 
   * @return uma lista de nomes completos das categorias
   */
  public List<String> getCategoryFullNameSet() {
    return categoryFullNames;
  }

  /**
   * Constri o elemento xml que descreve uma propriedade.
   */
  public XMLCategorySetElement() {
    super();
    setTag(XmlAlgorithmsPackUtils.CATEGORIES_TAG);
    categoryFullNames = new Vector<String>();
  }

  /**
   * Executado quando a tag de fim do elemento XML  encontrada. Deve-se criar o
   * objeto correspondente na camada da aplicao.
   * 
   * @see tecgraf.javautils.xml.XMLElementInterface#endTag(java.util.List)
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {
    String fullName = null;
    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);

    while (iterator.hasNext()) {
      XMLElementInterface nextElem = iterator.next();
      if (isCategoryElement(nextElem)) {
        fullName = getCategoryFullName(nextElem);
        if (fullName != null) {
          categoryFullNames.add(fullName);
        }
      }
    }
  }

  /**
   * Verifica se  o elemento que representa uma categoria do algoritmo.
   * 
   * @param xmlElem elemento xml
   * @return retorna true se o elemento representa uma categoria do algoritmo,
   *         caso contrrio, retorna false
   */
  private boolean isCategoryElement(XMLElementInterface xmlElem) {
    return xmlElem.getTag().equals(XmlAlgorithmsPackUtils.CATEGORY_TAG);
  }

  /**
   * Obtm o nome completo da categoria a partir do elemento xml especificado.
   * 
   * @param xmlElem elemento xml que especifica o nome completo da categoria
   * @return o nome completo da categoria
   */
  private String getCategoryFullName(XMLElementInterface xmlElem) {
    return xmlElem
      .getAttributeStrValue(XmlAlgorithmsPackUtils.CATEGORY_NAME_ATTR);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer arg0, String arg1) throws IOException {
    // TODO Auto-generated method stub

  }

}
