package csbase.logic.diagnosticservice;

import java.util.List;

import csbase.logic.diskusageservice.DiskOccupation;

/**
 * O status da ocupao em disco
 * 
 * @author Tecgraf PUC-Rio
 */
public class DiskStatus extends Status {

  /**
   * A ocupao do disco
   */
  public final DiskOccupation diskOccupation;

  /**
   * Construtor.
   * 
   * @param serverDiskOccupation a ocupao do disco
   * @param resourceName nome do recurso
   * @param code cdigo do estado
   * @param validationStatuses lista de {@link ValidationStatus}
   * @param properties lista de parmetros
   */
  public DiskStatus(DiskOccupation serverDiskOccupation, String resourceName,
    StatusCode code, ValidationStatus[] validationStatuses,
    List<ResourceProperty> properties) {
    super(resourceName, code, validationStatuses, properties);
    this.diskOccupation = serverDiskOccupation;
  }
}
