package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro que sempre retorna falso.
 * 
 * @author Tecgraf
 */
public final class ProjectFileFalseFilter implements ProjectFileFilter {
  /**
   * Instncia do filtro.
   */
  private static final ProjectFileFalseFilter instance =
    new ProjectFileFalseFilter();

  /**
   * Construtor.
   */
  private ProjectFileFalseFilter() {
    // vazio
  }

  /**
   * @return instncia do filtro
   */
  public static ProjectFileFalseFilter getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  public boolean accept(ClientProjectFile file) {
    return true;
  }
}