/**
 * $Id$
 */
package csbase.logic.openbus;

import java.io.Serializable;

/**
 * Representa uma credencial de um usurio no OpenBus.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class Credential implements Serializable {
  /**
   * O identificador da credencial.
   */
  private String identifier;
  /**
   * O dono da credencial.
   */
  private String owner;
  /**
   * O usurio delegado pelo dono da credencial (opcional).
   */
  private String delegate;

  /**
   * Cria uma credencial.
   * 
   * @param identifier O identificador da credencial.
   * @param owner O dono da credencial.
   * @param delegate O usurio delegado pelo dono da credencial (opcional).
   */
  public Credential(String identifier, String owner, String delegate) {
    if (identifier == null) {
      throw new IllegalArgumentException("identifier == null");
    }
    if (owner == null) {
      throw new IllegalArgumentException("owner == null");
    }
    if (delegate == null) {
      throw new IllegalArgumentException("delegate == null");
    }

    this.identifier = identifier;
    this.owner = owner;
    this.delegate = delegate;
  }

  /**
   * Obtm o identificador da credencial.
   * 
   * @return O identificador da credencial.
   */
  public String getIdentifier() {
    return this.identifier;
  }

  /**
   * Obtm o dono da credencial.
   * 
   * @return O dono da credencial.
   */
  public String getOwner() {
    return this.owner;
  }

  /**
   * Obtm o usurio delegado pelo dono da credencial (opcional)
   * 
   * @return O usurio delegado pelo dono da credencial (opcional).
   */
  public String getDelegate() {
    return this.delegate;
  }
}
