/**
 * $Id$
 */
package csbase.remote;

import csbase.exception.CSBaseException;
import csbase.logic.EncryptedPassword;
import csbase.logic.LoginPasswordCipher;
import csbase.logic.Session;

import java.rmi.RemoteException;
import java.security.PublicKey;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Representa um autenticador de usurios no servidor atravs do mtodo de login
 * e senha.
 * 
 * @author Tecgraf/PUC-RIo
 */
public final class UserPasswordAuthenticator implements Authenticator {
  /**
   * O login do usurio.
   */
  private String login;
  /**
   * A senha do usurio.
   */
  private String password;
  /**
   * A locale escolhida pelo usurio.
   */
  private Locale locale;

  /**
   * Cria um autenticador de usurios no servidor atravs do mtodo de login e
   * senha.
   * 
   * @param login O login do usurio.
   * @param password A senha do usurio.
   * @param locale A locale escolhida pelo usurio.
   */
  public UserPasswordAuthenticator(String login, String password, Locale locale) {
    this.login = login;
    this.password = password;
    this.locale = locale;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Session authenticate(ServerEntryPoint server) throws CSBaseException {
    TimeZone tz = TimeZone.getDefault();
    try {
      PublicKey publicKey = server.getPublicKey();
      EncryptedPassword encryptedPassword =
        LoginPasswordCipher.encrypt(this.password, publicKey);
      return server.login(this.login, encryptedPassword, this.locale, tz);
    }
    catch (RemoteException e) {
      throw new CSBaseException(e);
    }
  }
}
