/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.exception.algorithms.ExpressionFunctionNotFoundException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.ReflectionExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public final class ExpressionFunctionExecutor {
    private static ExpressionFunctionExecutor instance;
    private Set<ExpressionFunction> expressionFunctions = new HashSet<ExpressionFunction>();

    private ExpressionFunctionExecutor() {
        this.createExpressionFunctions();
    }

    public static ExpressionFunctionExecutor getInstance() {
        if (instance == null) {
            instance = new ExpressionFunctionExecutor();
        }
        return instance;
    }

    private void createExpressionFunctions() {
        String funcPropName;
        String classPropName;
        String className;
        String thisClassName = this.getClass().getSimpleName();
        String resName = thisClassName + ".properties";
        InputStream inStream = this.getClass().getResourceAsStream(resName);
        Properties properties = new Properties();
        try {
            properties.load(inStream);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        int ix = 0;
        while ((className = properties.getProperty(classPropName = "class." + ix)) != null) {
            Class<?> functionsClass;
            try {
                functionsClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException(cnfe);
            }
            if (functionsClass == null) {
                throw new IllegalStateException("Null functionClass! (class.ix)");
            }
            this.createReflexiveExpressionFunctions(functionsClass);
            ++ix;
        }
        ix = 0;
        while ((className = properties.getProperty(funcPropName = "function." + ix)) != null) {
            Class<?> functionClass;
            try {
                functionClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException(cnfe);
            }
            if (functionClass == null) {
                throw new IllegalStateException("Null functionClass! (function.ix)");
            }
            try {
                Constructor<?> constructor = functionClass.getConstructor(new Class[0]);
                ExpressionFunction function = (ExpressionFunction)constructor.newInstance(new Object[0]);
                this.addExpressionFunction(function);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            ++ix;
        }
    }

    public void createReflexiveExpressionFunctions(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            this.addExpressionFunction(new ReflectionExpressionFunction(method));
        }
    }

    public boolean addExpressionFunction(ExpressionFunction expressionFunction) {
        if (expressionFunction == null) {
            throw new IllegalArgumentException("O par\u00e2metro expressionFunction est\u00e1 nulo.");
        }
        return this.expressionFunctions.add(expressionFunction);
    }

    public boolean addAllExpressionFunction(Set<ExpressionFunction> expFunctions) {
        if (expFunctions == null) {
            throw new IllegalArgumentException("O par\u00e2metro expressionFunctions est\u00e1 nulo.");
        }
        return this.expressionFunctions.addAll(expFunctions);
    }

    public Object execute(String functionName, SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException, ExpressionFunctionNotFoundException {
        if (functionName == null) {
            throw new IllegalArgumentException("O par\u00e2metro functionName n\u00e3o foi encontrado.");
        }
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameters n\u00e3o foi encontrado.");
        }
        for (ExpressionFunction expressionFunction : this.expressionFunctions) {
            if (!expressionFunction.getName().equals(functionName) || !expressionFunction.acceptParameters(parameters)) continue;
            return expressionFunction.execute(configurator, parameters);
        }
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        throw new ExpressionFunctionNotFoundException(functionName, parameterTypes);
    }

    public Set<ExpressionFunction> getExpressionFunctions() {
        return Collections.unmodifiableSet(this.expressionFunctions);
    }

    public void clear() {
        this.expressionFunctions.clear();
    }
}

