/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

public final class ProjectFileRecursiveFilter
implements ProjectFileFilter {
    private ProjectFileFilter filter;

    public ProjectFileRecursiveFilter(ProjectFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.filter = filter;
    }

    @Override
    public boolean accept(ClientProjectFile file) {
        if (this.filter.accept(file)) {
            return true;
        }
        if (file.isDirectory()) {
            ClientProjectFile[] children = file.getLocalChildren();
            if (children == null) {
                return false;
            }
            for (ClientProjectFile child : children) {
                if (!this.accept(child)) continue;
                return true;
            }
        }
        return false;
    }
}

