/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DefaultEnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parsers.XmlParser;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public final class EnumerationItemFactory
implements Serializable {
    public static final String ELEMENT_NAME = "item_de_enumeracao";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "dica";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String LABEL_ATTRIBUTE_NAME = "rotulo";
    private static final String VALUE_ATTRIBUTE_NAME = "valor";

    public List<EnumerationItem> loadEnumerationItems(XmlParser parser, String parameterName) throws ParseException {
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        if (parser.goToFirstChild(ELEMENT_NAME)) {
            do {
                EnumerationItem enumerationItem;
                if (items.contains(enumerationItem = this.loadEnumerationItem(parser, parameterName))) {
                    throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getId(), parameterName);
                }
                for (EnumerationItem item : items) {
                    if (!enumerationItem.getLabel().equals(item.getLabel())) continue;
                    throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getLabel(), parameterName);
                }
                items.add(enumerationItem);
            } while (parser.goToNextSibling(ELEMENT_NAME));
            parser.goToParent();
        }
        return items;
    }

    public EnumerationItem loadEnumerationItem(XmlParser parser, String parameterName) throws ParseException {
        try {
            String elementName = parser.getElementName();
            if (!elementName.equals(ELEMENT_NAME)) {
                throw new ParseException("O nome do elemento do XML encontrado {0} n\u00e3o \u00e9 suportado. Suportado: {1}.", elementName, ELEMENT_NAME);
            }
            String id = parser.extractAttributeValue(ID_ATTRIBUTE_NAME);
            String label = parser.extractAttributeValue(LABEL_ATTRIBUTE_NAME);
            String value = parser.extractAttributeValue(VALUE_ATTRIBUTE_NAME);
            String description = parser.extractAttributeValue(DESCRIPTION_ATTRIBUTE_NAME, null);
            parser.checkAttributes();
            parser.checkChildElements();
            DefaultEnumerationItem enumerationItem = new DefaultEnumerationItem(id, label, value, description);
            return enumerationItem;
        }
        catch (ParseException e) {
            throw new ParseException("Erro ao tentar criar item de enumera\u00e7\u00e3o para a enumera\u00e7\u00e3o {0}.", parameterName);
        }
    }

    public EnumerationItem getEnumerationItem(String enumerationName, List<EnumerationItem> items, String itemId) throws ParseException {
        for (EnumerationItem item : items) {
            if (!item.getId().equals(itemId)) continue;
            return item;
        }
        throw new ParseException("Erro ao tentar criar a enumera\u00e7\u00e3o {0}: O item padr\u00e3o {1} n\u00e3o est\u00e1 definido.", enumerationName, itemId);
    }
}

