package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * Representa que um comando foi removido do agendador de comandos.
 *
 * @author Tecgraf / PUC-Rio
 */
public class SchedulerCommandRemovedEvent extends RemoteEvent {

  /** Comando removido. */
  private CommandInfo cmd;
  
  /**
   * Construtor.
   * 
   * @param cmd O comando removido.
   */
  public SchedulerCommandRemovedEvent(CommandInfo cmd) {
    this.cmd = cmd;
  }

  /**
   * Obtm o comando removido.
   * @return O comando removido.
   */
  public CommandInfo getCommandInfo() {
    return cmd;
  }
}
