package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * Informaes sobre uma propriedade do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class PropertyInfo implements Serializable, Comparable<PropertyInfo> {
  /** Chave da propriedade */
  public final String key;
  /** Valor corrente */
  public String runtimeValue;
  /** Valor no arquivo de configurao do servio */
  public String serviceValue;
  /** Valor no arquivo de configurao do servidor (Server.properties) */
  public String serverValue;
  /** Valor no arquivo de configurao do sistema */
  public String systemValue;
  /** Valor na linha de comando */
  public String commandLineValue;

  /**
   * Construtor.
   * 
   * @param key chave
   * @param runtimeValue valor corrente
   * @param serviceValue valor no arquivo de configurao do servio
   * @param serverValue valor no arquivo de configurao do servidor
   *        (Server.properties)
   * @param systemValue valor no arquivo de configurao do sistema
   * @param commandLineValue valor na linha de comando
   */
  public PropertyInfo(String key, String runtimeValue, String serviceValue,
    String serverValue, String systemValue, String commandLineValue) {
    this.key = key;
    this.runtimeValue = runtimeValue;
    this.serviceValue = serviceValue;
    this.serverValue = serverValue;
    this.systemValue = systemValue;
    this.commandLineValue = commandLineValue;
  }

  /**
   * Construtor.
   * 
   * @param key chave
   */
  public PropertyInfo(String key) {
    this.key = key;
  }

  /**
   * Atribui o valor definido na configurao do servio.
   * 
   * @param value o valor definido no servio
   */
  public void setServiceValue(String value) {
    this.serviceValue = value;
  }

  /**
   * Atribui o valor em tempo de execuo.
   * 
   * @param value o valor em tempo de execuo
   */
  public void setRuntimeValue(String value) {
    this.runtimeValue = value;
  }

  /**
   * Atribui o valor atribudo por linha de comando.
   * 
   * @param value o valor atribudo por linha de comando
   */
  public void setCommandLineValue(String value) {
    this.commandLineValue = value;
  }

  /**
   * Atribui o valor atribudo no arquivo Server.properties.
   * 
   * @param value o valor atribudo no arquivo de configurao Server.properties
   */
  public void setServerValue(String value) {
    this.serverValue = value;
  }

  /**
   * {@inheritDoc}
   * 
   * Compara por ordem alfabtica da chave.
   */
  @Override
  public int compareTo(PropertyInfo other) {
    return this.key.compareTo(other.key);
  }
}
