/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeDefaultValueTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AbstractSimpleTriggerFactory;

public final class ChangeDefaultValueTriggerFactory
extends AbstractSimpleTriggerFactory {
    private static final String NEW_DEFAULT_VALUE_ATTRIBUTE = "novo_valor_padrao";

    public ChangeDefaultValueTriggerFactory() {
        super("trocar_valor_padrao", false);
    }

    @Override
    protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition, Parameter<?> parameter, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parameter instanceof TextParameter) {
            TextParameter textParam = (TextParameter)parameter;
            String defaultValue = parser.extractAttributeValue(NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            return new ChangeDefaultValueTrigger<String>(textParam, condition, defaultValue);
        }
        if (parameter instanceof IntegerParameter) {
            IntegerParameter intParam = (IntegerParameter)parameter;
            Integer defaultValue = parser.extractAttributeValueAsInteger(NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            return new ChangeDefaultValueTrigger<Integer>(intParam, condition, defaultValue);
        }
        if (parameter instanceof DoubleParameter) {
            DoubleParameter doubleParam = (DoubleParameter)parameter;
            Double defaultValue = parser.extractAttributeValueAsDouble(NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            return new ChangeDefaultValueTrigger<Double>(doubleParam, condition, defaultValue);
        }
        if (parameter instanceof BooleanParameter) {
            BooleanParameter booleanParam = (BooleanParameter)parameter;
            Boolean defaultValue = new Boolean(parser.extractAttributeValueAsBoolean(NEW_DEFAULT_VALUE_ATTRIBUTE));
            return new ChangeDefaultValueTrigger<Boolean>(booleanParam, condition, defaultValue);
        }
        if (parameter instanceof EnumerationParameter) {
            EnumerationParameter enumParameter = (EnumerationParameter)parameter;
            EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
            String itemId = parser.extractAttributeValue(NEW_DEFAULT_VALUE_ATTRIBUTE);
            EnumerationItem defaultValue = enumerationParameter.getItem(itemId);
            if (defaultValue == null) {
                throw new ParseException("O item de enumera\u00e7\u00e3o {0} n\u00e3o est\u00e1 presente na enumera\u00e7\u00e3o {1}.", itemId, parameter);
            }
            return new ChangeDefaultValueTrigger<EnumerationItem>(enumParameter, condition, defaultValue);
        }
        throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4};\n{5}.", parameter.getName(), "texto", "inteiro", "real", "booleano", "enumeracao");
    }
}

