/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ClientSGAFileParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.ArrayAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;
import java.util.List;

public class ClientSGAFileParameterFactory
extends SimpleParameterParser<ClientSGAFileParameter> {
    private static final String MULTIPLE_SELECTION_ATTRIBUTE = "selecao_multipla";
    private static final String CATEGORY_ATTRIBUTE = "categoria";
    private static final String CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE = "arquivo";
    private static final String CATEGORY_ATTRIBUTE_VALUE_DIRECTORY = "diretorio";
    private static final String MODE_ATTRIBUTE = "modo";
    private static final String MODE_ATTRIBUTE_VALUE_INPUT = "entrada";
    private static final String MODE_ATTRIBUTE_VALUE_OUTPUT = "saida";
    private static final String TYPE_ATTRIBUTE = "tipo";
    public static final String CLIENT_SGA_PARAMETER_ELEMENT = "arquivo_sga";

    @Override
    public ClientSGAFileParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ClientSGAFileParameter parameter = new ClientSGAFileParameter(definition.getName(), definition.getLabel(), definition.getDescription(), null, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern());
        parameter.setMultipleSelection((Boolean)definition.getAttributeValue(MULTIPLE_SELECTION_ATTRIBUTE));
        String category = parser.extractAttributeValue(CATEGORY_ATTRIBUTE, CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE);
        if (!category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE) && !category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_DIRECTORY)) {
            category = CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE;
        }
        parameter.setShowFiles(category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE));
        String mode = parser.extractAttributeValue(MODE_ATTRIBUTE, MODE_ATTRIBUTE_VALUE_INPUT);
        if (!mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_INPUT) && !mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_OUTPUT)) {
            mode = MODE_ATTRIBUTE_VALUE_INPUT;
        }
        parameter.setInputMode(mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_INPUT));
        parameter.setTypes((List)definition.getAttributeValue(TYPE_ATTRIBUTE));
        if (parameter.isMultipleSelection() && !parameter.isInputMode()) {
            throw new ParseException("O par\u00e2metro " + definition.getName() + " n\u00e3o pode ser configurado simultaneamente para sele\u00e7\u00e3o " + "" + "m\u00faltipla e modo save.");
        }
        return parameter;
    }

    @Override
    public ParameterStructure<ClientSGAFileParameter> getParameterStructure() {
        SimpleParameterStructure<ClientSGAFileParameter> structure = new SimpleParameterStructure<ClientSGAFileParameter>(CLIENT_SGA_PARAMETER_ELEMENT, ClientSGAFileParameter.class);
        structure.addAttribute(new BooleanAttribute(MULTIPLE_SELECTION_ATTRIBUTE, false));
        structure.addAttribute(new StringAttribute(CATEGORY_ATTRIBUTE, CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE));
        structure.addAttribute(new StringAttribute(MODE_ATTRIBUTE, MODE_ATTRIBUTE_VALUE_INPUT));
        structure.addAttribute(new ArrayAttribute(TYPE_ATTRIBUTE, null));
        return structure;
    }
}

