/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.EnumerationAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringToValueConverter;

public class FileElementPipeAcceptanceAttribute
extends EnumerationAttribute<FileParameterPipeAcceptance> {
    public FileElementPipeAcceptanceAttribute(String name) {
        super(name, FileParameterPipeAcceptance.class, new FileParameterPipeAcceptanceConverter());
    }

    public FileElementPipeAcceptanceAttribute(String name, FileParameterPipeAcceptance defaultValue) {
        super(name, FileParameterPipeAcceptance.class, defaultValue, null, new FileParameterPipeAcceptanceConverter());
    }

    public static class FileParameterPipeAcceptanceConverter
    implements StringToValueConverter<FileParameterPipeAcceptance> {
        public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
            switch (value) {
                case TRUE: {
                    return BooleanAttribute.TRUE_VALUES;
                }
                case FALSE: {
                    return BooleanAttribute.FALSE_VALUES;
                }
                case ALWAYS: {
                    return new String[]{"sempre", "always"};
                }
            }
            throw new BugException();
        }

        @Override
        public FileParameterPipeAcceptance valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(mode)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return mode;
                    }
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de " + "enumera\u00e7\u00e3o do tipo " + FileParameterPipeAcceptance.class.getName());
        }
    }
}

