package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.TextSctructureAttributes
  .TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.TextSctructureAttributes
  .TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE;
import static csbase.logic.algorithms.parsers.elements
  .SimpleParameterStructure.PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;

/**
 * <p>
 * Analisador de {@link TextParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo texto. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link TextParameter}.
 * </p>
 */
public class TextParameterFactory extends SimpleParameterParser<TextParameter> {

  /**
   * <p>
   * O elemento {@value #TEXT_PARAMETER_ELEMENT}: descreve as propriedades de um
   * {@link TextParameter parmetro do tipo texto}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String TEXT_PARAMETER_ELEMENT = "texto";

  /**
   * {@inheritDoc}
   */
  @Override
  public TextParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    String defaultValue =
      definition.getAttributeValue(PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    Integer maxCharacters =
      definition.getAttributeValue(TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE);
    return new TextParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), defaultValue, definition.isOptional(),
      definition.isVisible(), definition.getCommandLinePattern(),
      maxCharacters);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<TextParameter> getParameterStructure() {
    ParameterStructure<TextParameter> textStructure =
      new SimpleParameterStructure<>(TEXT_PARAMETER_ELEMENT,
        TextParameter.class);
    textStructure.addAttribute(
      new IntegerAttribute(TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE, null,
        TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE, null));
    textStructure.addAttribute(
      new StringAttribute(PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null));
    return textStructure;
  }

}
