/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.attributes.AbstractElementAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringToValueConverter;

public class BooleanAttribute
extends AbstractElementAttribute<Boolean> {
    static final String[] FALSE_VALUES = new String[]{"falso", "false", "F", "nao", "n\u00e3o", "no", "N"};
    static final String[] TRUE_VALUES = new String[]{"verdadeiro", "true", "V", "T", "sim", "yes", "S", "Y"};

    BooleanAttribute(String name, boolean optional, Boolean defaultValue, BooleanAttribute defaultValueAttribute) {
        super(name, Boolean.class, optional, defaultValue, defaultValueAttribute);
    }

    public BooleanAttribute(String name) {
        this(name, false, null, null);
    }

    public BooleanAttribute(String name, Boolean defaultValue) {
        this(name, true, defaultValue, null);
    }

    @Override
    public StringToValueConverter<Boolean> getValueConverter() {
        return new StringToBooleanConverter();
    }

    private class StringToBooleanConverter
    implements StringToValueConverter<Boolean> {
        private StringToBooleanConverter() {
        }

        @Override
        public Boolean valueOf(String value) throws ParseException {
            for (String trueValue : TRUE_VALUES) {
                if (!trueValue.equalsIgnoreCase(value)) continue;
                return true;
            }
            for (String falseValue : FALSE_VALUES) {
                if (!falseValue.equalsIgnoreCase(value)) continue;
                return false;
            }
            throw new ParseException("O valor {1} do atributo {0} n\u00e3o \u00e9 do tipo booleano.", BooleanAttribute.this.getName(), value);
        }
    }
}

