/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.ConditionParser;
import csbase.logic.algorithms.parsers.triggers.TriggerFactory;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstracTriggerFactory
implements TriggerFactory {
    private String elementName;
    private String parameterAttributeName;
    private String parameterElementName;
    private String parameterNameAttributeName;
    private boolean allowMultiples;

    protected AbstracTriggerFactory(String elementName, String parameterElementName, String parameterNameAttributeName, String parameterAttributeName, boolean allowMultiples) {
        this.elementName = elementName;
        this.parameterElementName = parameterElementName;
        this.parameterNameAttributeName = parameterNameAttributeName;
        this.parameterAttributeName = parameterAttributeName;
        this.allowMultiples = allowMultiples;
    }

    @Override
    public final String getElementName() {
        return this.elementName;
    }

    @Override
    public final Set<Trigger<?>> createTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Condition condition = this.loadTriggerCondition(parser, configurator);
        HashSet triggers = new HashSet();
        Set<Parameter<?>> parameters = this.loadTriggerParameters(parser, configurator);
        for (Parameter<?> parameter : parameters) {
            triggers.add(this.doCreateTrigger(parser, condition, parameter, configurator));
        }
        parser.checkAttributes();
        return triggers;
    }

    protected abstract Trigger<?> doCreateTrigger(XmlParser var1, Condition var2, Parameter<?> var3, SimpleAlgorithmConfigurator var4) throws ParseException;

    protected abstract Parameter<?> findParameter(SimpleAlgorithmConfigurator var1, String var2) throws OperationFailureException;

    private Set<Parameter<?>> loadTriggerParameters(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Parameter<?> parameter;
        String elementName = parser.getElementName();
        HashSet parameters = new HashSet();
        String parameterName = parser.extractAttributeValue(this.parameterAttributeName, null);
        if (parameterName != null) {
            try {
                parameter = this.findParameter(configurator, parameterName);
            }
            catch (OperationFailureException e) {
                throw new ParseException(e, "Falha ao tentar localizar o par\u00e2metro {0}", parameterName);
            }
            if (parameter == null) {
                throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, elementName, this.parameterAttributeName);
            }
            parameters.add(parameter);
        }
        if (parser.goToFirstChild(this.parameterElementName)) {
            do {
                parameterName = parser.getAttributeValue(this.parameterNameAttributeName);
                try {
                    parameter = this.findParameter(configurator, parameterName);
                }
                catch (OperationFailureException e) {
                    throw new ParseException(e, "Falha ao tentar localizar o par\u00e2metro {0}", parameterName);
                }
                if (parameter == null) {
                    throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, this.parameterElementName, this.parameterAttributeName);
                }
                parameters.add(parameter);
            } while (parser.goToNextSibling(this.parameterElementName));
            parser.goToParent();
        }
        if (parameters.isEmpty()) {
            throw new ParseException(String.format("Os par\u00e2metros associados ao gatilho representado pelo elemento %s n\u00e3o foram informados.", elementName));
        }
        if (!this.allowMultiples && parameters.size() > 1) {
            throw new ParseException(String.format("O gatilho representado pelo elemento %s n\u00e3o pode ser utilizado para mais do que 1 par\u00e2metro.", elementName));
        }
        return parameters;
    }

    private Condition loadTriggerCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Condition condition = null;
        if (parser.goToFirstChild("condicao") || parser.goToFirstChild("ou") || parser.goToFirstChild("e") || parser.goToFirstChild("nao")) {
            ConditionParser conditionParser = new ConditionParser();
            condition = conditionParser.loadCondition(parser, configurator);
            parser.goToParent();
            return condition;
        }
        throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
    }
}

