/*
 * $Id: Notification.java 175681 2016-09-01 19:33:23Z clinio $
 */

package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * Representa uma notificao remota.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class Notification extends RemoteEvent {
  /**
   * Identificao de quem enviou a notificao.
   */
  private String sender;

  /**
   * Indica se a notificao deve ser exibida no painel de mensagens.
   */
  private boolean display;

  /**
   * Indica se a notificao deve ser exibida em um dilogo popup.
   */
  private boolean mustPopUp;

  /**
   * Informa a identificao de quem enviou a notificao.
   * 
   * @return Identificao de quem enviou a notificao.
   */
  public String getSender() {
    return sender;
  }

  /**
   * Indica se a notificao deve ser exibida no painel de mensagens.
   * 
   * @return true caso deva ser exibida no painel, false caso contrrio.
   */
  public boolean getDisplay() {
    return this.display;
  }

  /**
   * Ajusta se a notificao deve ser exibida no painel de mensagens.
   * 
   * @param display true caso deva ser exibida no painel, false caso contrrio.
   */
  public void setDisplay(boolean display) {
    this.display = display;
  }

  /**
   * Indica se a notificao deve ser exibida em um dilogo popup.
   * 
   * @return true caso deva ser exibida em um popup, false caso contrrio.
   */
  public boolean getMustPopUp() {
    return this.mustPopUp;
  }

  /**
   * Indica se a notificao  voltil ou no. Notificaes volteis so
   * descartadas caso no consigam ser entregues aos destinatrios na primeira
   * tentativa.
   * 
   * @return true se for voltil, false caso contrrio.
   */
  public abstract boolean isVolatile();

  /**
   * Requer esta implementao apenas para auditagem nos logs do servidor. Este
   * mtodo <u>no</u> define o texto que vai ser exibido para o usurio.
   */
  @Override
  public abstract String toString();

  /**
   * Construtor para configurao padro: display==true e mustPopUp==false.
   * 
   * @param sender Identificao de quem enviou a notificao.
   */
  protected Notification(String sender) {
    this(sender, true, false);
  }

  /**
   * Construtor
   * 
   * @param sender Identificao de quem enviou a notificao.
   * @param display Indica se a mensagem deve ser exibida no painel de
   *        mensagens.
   * @param mustPopUp Indica se a mensagem deve ser exibida em um dilogo popup.
   */
  protected Notification(String sender, boolean display, boolean mustPopUp) {
    if (sender == null) {
      throw new IllegalArgumentException("sender == null");
    }
    this.sender = sender;
    this.display = display;
    this.mustPopUp = mustPopUp;
  }
}
