/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;

import java.util.List;

/**
 * <p>
 * Parmetro do tipo lista de arquivo de entrada.
 * </p>
 * <p>
 * Ele possui 3 modos de funcionamento: aceitar apenas arquivos regulares,
 * aceitar apenas diretrios ou aceitar arquivos regulares e diretrios (veja
 * {@link FileParameterMode}).
 * </p>
 */
public final class InputFileListParameter extends FileListParameter {

  /** Texto que representa o tipo desse parmetro */
  public static final String TYPE = "INPUT_FILE";

  /**
   * Cria um parmetro do tipo arquivo.
   *
   * @param name O nome deste parmetro (No aceita {@code null}).
   * @param label O rtulo deste parmetro (No aceita {@code null}).
   * @param description A descrio deste parmetro (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se o valor do parmetro  opcional.
   * @param isVisible Indica se o parmetro deve ficar visvel.
   * @param commandLinePattern O padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param fileTypes Os tipos dos arquivos aceitos neste parmetro (Aceita
   *        {@code null}).
   * @param mode O modo de funcionamento deste parmetro (No aceita
   *        {@code null}).
   * @param mustSort Indica se os caminhos para os arquivos precisam ser
   *        ordenados.
   * @param usesFilter Indica se um painel de filtro pode ser usado.
   */
  public InputFileListParameter(String name, String label, String description,
    List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String[] fileTypes, FileParameterMode mode,
    boolean mustSort, boolean usesFilter) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, fileTypes, mode, mustSort, usesFilter, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getType() {
    return TYPE;
  }
}
