package csbase.logic;

/**
 * Modela um usurio autenticado por algum mecanismo externo. Basicamente 
 * apenas a String com a identificao do usurio.
 *
 * Essa classe  necessria para diferenciar um usurio autenticado
 * externamente (como pelos servios REST ou OpenBus) de uma requisio
 * interna do servidor. Em geral, quando se fornece a autenticao do usurio
 * como uma String ao invs de uma {@link SecureKey}, o cdigo do CSBase
 * considera que  uma chamada interna do servidor e que no deve fazer
 * verificaes sobre permisses de leitura desse usurio.
 *
 * Alm disso, a diferenciao tambm se mostra necessria devido a usurios
 * externos no manterem sesses CSBase ativas.
 */
public class ExternalUser {
  private String key;
  private ExternalAuthMechanism from;

  public enum ExternalAuthMechanism {
    OPENBUS,
    REST,
  }

  /**
   * Instancia a classe com valores imutveis.
   *
   * @param key Chave identificadora do usurio.
   * @param from Identificador do mecanismo de autenticao externo.
   */
  public ExternalUser(String key, ExternalAuthMechanism from) {
    this.key = key;
    this.from = from;
  }

  public String getKey() {
    return key;
  }

  public ExternalAuthMechanism getFrom() {
    return from;
  }
}
