/**
 * $Id$
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Dados do projeto que so armazenados para a lista de projetos abertos
 * recentemente
 *
 * @author Tecgraf
 */
public class ProjectBasicInfo implements Serializable {

  /**
   * Identificador do projeto.
   */
  private Object projectId;

  /**
   * Nome do projeto.
   */
  private String name;

  /**
   * Identificador do usurio dono do projeto.
   */
  private Object userId;

  /**
   * Login do dono do projeto
   */
  private String userLogin;

  /**
   * Construtor
   * 
   * @param projectId Id do Projeto
   * @param name Nome do Projeto
   * @param userId Id do dono do projeto
   */
  public ProjectBasicInfo(Object projectId, String name, Object userId) {
    this.projectId = projectId;
    this.name = name;
    this.userId = userId;
  }

  /**
   * 
   * @return Id do Projeto
   */
  public Object getProjectId() {
    return projectId;
  }

  /**
   * 
   * @return Nome do Projeto
   */
  public String getName() {
    return name;
  }

  /**
   * 
   * @return O Id do dono do projeto
   */
  public Object getUserId() {
    return userId;
  }

  /**
   * Retorna o Login do usurio dono do projeto
   *
   * @return userLogin login do dono do projeto
   */
  public String getUserLogin() {
    return userLogin;
  }

  /**
   * @param userLogin o login do dono do projeto
   */
  public void setUserLogin(String userLogin) {
    this.userLogin = userLogin;
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object other) {
    if (!(other instanceof ProjectBasicInfo)) {
      return false;
    }
    ProjectBasicInfo otherInfo = (ProjectBasicInfo) other;
    if (projectId == null || otherInfo.projectId == null) {
      return false;
    }
    return projectId.equals(otherInfo.projectId);
  }

}
