package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineContext;

/**
 * Coluna bsica: fornece sugestes de implementaes de alguns mtodos
 * abstratos da {@link TableColumn}.
 * 
 * @param <T> O tipo de dado armazenada
 * 
 * @author lmoreira
 */
public abstract class BasicColumn<T> extends TableColumn<T> {

  /**
   * Texto utilizado quando o valor da clula est em branco.
   */
  private static final String EMPTY_CELL_COMMAND_VALUE = "NULL";

  /**
   * Cria uma coluna bsica.
   * 
   * @param id O identificador (No aceita {@code null}).
   * @param label O rtulo (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se a coluna  opcional/obrigatria.
   * @param isEditable Indica se a coluna  editvel.
   */
  protected BasicColumn(String id, String label, T defaultValue,
    boolean isOptional, boolean isEditable) {
    super(id, label, defaultValue, isOptional, isEditable);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getCommandValue(T itemValue, CommandLineContext context) {
    if (itemValue == null) {
      return EMPTY_CELL_COMMAND_VALUE;
    }
    return itemValue.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getItemValueAsText(T itemValue) {
    if (itemValue == null) {
      return null;
    }
    return itemValue.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueToExport(T itemValue) {
    return itemValue;
  }

  /**
   * {@inheritDoc}
   */
  @SuppressWarnings("unchecked")
  @Override
  public T getValueToImport(Object importedValue) {
    return (T) importedValue;
  }
}
